#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmBloodProductEdit;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ProductShipper : BaseTest 
	{

		private System.Guid _psGuid;
		private System.Guid _bpGuid;
		private System.Guid _localSupplierGuid;

		private DataTable _dtShipper;
		
		private BOL.ProductShipper _tstPS;


		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtShipper = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 PS.*, S.ShipmentGuid FROM ProductShipper PS  JOIN SHIPMENT S ON S.LocalSupplierGuid = PS.LocalSupplierGuid WHERE PS.RecordStatusCode = 'A' AND PS.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' ORDER BY PS.LastUpdateDate DESC", true);

				this._bpGuid = (System.Guid)this._dtShipper.Rows[0][TABLES.ProductShipper.BloodProductGuid];
				this._psGuid = (System.Guid)this._dtShipper.Rows[0][TABLES.ProductShipper.ProductShipperGuid];
				this._localSupplierGuid = (System.Guid)this._dtShipper.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];

				this.RefreshData = false;
			}

			this._tstPS = new BOL.ProductShipper(this._dtShipper.Rows[0]);
			this._tstPS.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.NewProductSupplier);
		}

		[Test]
		public void Ctor_Guid_Guid_Pass()
		{
			BOL.ProductShipper tmpPS = new BOL.ProductShipper(this._psGuid, this._bpGuid);

			Assert.IsNotNull(tmpPS);
			Assert.AreEqual(tmpPS.ProductShipperGuid, this._psGuid);
			Assert.AreEqual(tmpPS.BloodProductGuid, this._bpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Guid_Fail()
		{
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.ProductShipper tmpPS = new BOL.ProductShipper(this._psGuid);

			Assert.IsNotNull(tmpPS);
			Assert.AreEqual(tmpPS.ProductShipperGuid, this._psGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.ProductShipper tmpPS = new BOL.ProductShipper(this._dtShipper.Rows[0]);

			Assert.IsNotNull(tmpPS);
			Assert.AreEqual(tmpPS.ProductShipperGuid, this._psGuid);
			Assert.AreEqual(tmpPS.BloodProductGuid, this._bpGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void ProductShipperGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPS.ProductShipperGuid = tstValue;

			Assert.AreEqual(this._tstPS.ProductShipperGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ProductShipperGuid_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			Common.RecordStatusCode tstValue = Common.RecordStatusCode.Historical;

			this._tstPS.RecordStatusCode = tstValue;

			Assert.AreEqual(this._tstPS.RecordStatusCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}
		
		[Test]
		public void BloodProductGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPS.BloodProductGuid = tstValue;

			Assert.AreEqual(this._tstPS.BloodProductGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodProductGuid_Fail()
		{
		}

		
		[Test]
		public void LocalSupplierGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPS.LocalSupplierGuid = tstValue;

			Assert.AreEqual(this._tstPS.LocalSupplierGuid, tstValue);
			Assert.AreEqual(this._tstPS.IsRuleBroken(BROKEN.LocalSupplierGuid), false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LocalSupplierGuid_Fail()
		{
			this._tstPS.LocalSupplierGuid = System.Guid.Empty;

			Assert.AreEqual(this._tstPS.IsRuleBroken(BROKEN.LocalSupplierGuid), true);
		}

				
		[Test]
		public void ProductCost_Pass()
		{
			decimal tstValue = (decimal)new Random().Next(1,9999);

			this._tstPS.ProductCost = tstValue;

			Assert.AreEqual(this._tstPS.ProductCost, tstValue, "Value");
			Assert.AreEqual(false, this._tstPS.IsRuleBroken(BROKEN.ProductCost), "BROKEN.ProductCost");
		}

		[Test]
		public void ProductCost_Fail()
		{
			try
			{
				this._tstPS.ProductCost = decimal.One;	//turn off the broken rule
				this._tstPS.ProductCost = decimal.MinusOne;
				Assert.IsTrue(false,"BrokenRule.Negative");
			}
			catch(BrokenRuleException)
			{
				Assert.AreEqual(true, this._tstPS.IsRuleBroken(BROKEN.ProductCost), "BrokenRule.Negative");
			}

			try
			{
				this._tstPS.ProductCost = decimal.One;		//turn off the broken rule
				this._tstPS.ProductCost = 10000;
				Assert.IsTrue(false,"BrokenRule.>9,999");
			}
			catch(BrokenRuleException)
			{
				Assert.AreEqual(true, this._tstPS.IsRuleBroken(BROKEN.ProductCost), "BrokenRule.>9,999");
			}

			this._tstPS.ProductCost = decimal.One;		//turn off the broken rule
			this._tstPS.LocalSupplierGuid = System.Guid.NewGuid();
			this._tstPS.ProductCost = decimal.Zero;
			Assert.AreEqual(true, this._tstPS.IsRuleBroken(BROKEN.ProductCost), "BrokenRule.Zero");
		}
				
		[Test]
		public void FacilityName_Pass()
		{
			string tstValue = this._tstPS.FacilityName;

			Assert.AreEqual(this._tstPS.FacilityName, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void FacilityName_Fail()
		{
		}
				
		[Test]
		public void FDARegistrationNumber_Pass()
		{
			string tstValue = this._tstPS.FDARegistrationNumber;

			Assert.AreEqual(this._tstPS.FDARegistrationNumber, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void FDARegistrationNumber_Fail()
		{
		}

				
		[Test]
		public void ReturnCreditPercentage_Pass()
		{
			decimal tstValue = (decimal)new Random().Next(1,99);

			this._tstPS.ReturnCreditPercentage = tstValue;

			Assert.AreEqual(this._tstPS.ReturnCreditPercentage, tstValue);
			Assert.AreEqual(false, this._tstPS.IsRuleBroken(BROKEN.ReturnCreditPercentage), "BrokenRule");
		}

		[Test]
		public void ReturnCreditPercentage_Fail()
		{
			try
			{
				this._tstPS.ReturnCreditPercentage = decimal.One;	//turn off the broken rule
				this._tstPS.ReturnCreditPercentage = decimal.MinusOne;
				Assert.IsTrue(false,"BrokenRule.Negative");
			}
			catch(BrokenRuleException)
			{
				Assert.AreEqual(true, this._tstPS.IsRuleBroken(BROKEN.ReturnCreditPercentage), "BrokenRule.Negative");
			}

			try
			{
				this._tstPS.ReturnCreditPercentage = decimal.One;		//turn off the broken rule
				this._tstPS.ReturnCreditPercentage = 101;
				Assert.IsTrue(false,"BrokenRule.>101");
			}
			catch(BrokenRuleException)
			{
				Assert.AreEqual(true, this._tstPS.IsRuleBroken(BROKEN.ReturnCreditPercentage), "BrokenRule.>101");
			}
		}
				
		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = new byte[8];

			this._tstPS.RowVersion = tstValue;

			Assert.AreEqual(this._tstPS.RowVersion, tstValue);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void RowVersion_Fail()
		{
			this._tstPS.RowVersion = new byte[9];
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			BOL.ProductShipper tstValue = new BOL.ProductShipper(this._psGuid);

			DataRow drTest = tstValue.LoadDataRowFromThis(this._dtShipper.NewRow());

			Assert.AreEqual(this._psGuid, (System.Guid)drTest[TABLES.ProductShipper.ProductShipperGuid], TABLES.ProductShipper.ProductShipperGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void GetProductShippersByDivision_Pass()
		{
			DataTable dtTest = BOL.ProductShipper.GetProductShippersByDivision(this._bpGuid);
			Assert.IsTrue(dtTest.Rows.Count>0);
		}

		[Test]
		public void GetProductShippersByDivision_Fail()
		{
			DataTable dtTest = BOL.ProductShipper.GetProductShippersByDivision(System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);

		}

		[Test]
		public void GetProductShippersByDivisionLookUpList_Pass()
		{
			DataTable dtTest = BOL.ProductShipper.GetProductShippersByDivisionLookUpList();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductShippersByDivisionLookUpList_Fail()
		{
		}

		[Test]
		public void GetProductShippersByDivisionLookUpAL_Pass()
		{
			System.Collections.ArrayList alTest = BOL.ProductShipper.GetProductShippersByDivisionLookUpAL();
			Assert.IsTrue(alTest.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductShippersByDivisionLookUpAL_Fail()
		{
		}

		[Test]
		public void GetReimbursementPercentage_Pass()
		{
			DataRow drData = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 BloodUnitGuid, LocalSupplierGuid FROM vw_BloodShipFinanceAllCurrent WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A'");
			
			System.Guid buGuid = (System.Guid)drData[TABLES.BloodUnit.BloodUnitGuid];
			System.Guid lsGuid = (System.Guid)drData[TABLES.LocalSupplier.LocalSupplierGuid];

			//There should always be data out here--but, someday I really should write a method to make my own and test for that value
			decimal tstValue = BOL.ProductShipper.GetReimbursementPercentage(buGuid, lsGuid);
			Assert.IsTrue(tstValue >= 0);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetReimbursementPercentage_Fail()
		{
			decimal tstValue = BOL.ProductShipper.GetReimbursementPercentage(System.Guid.NewGuid(), System.Guid.NewGuid());
		}

		[Test]
		public void Insert_Pass()
		{
			Guid productShipperGuid = Guid.NewGuid();
			//
			BOL.ProductShipper ps = new ProductShipper( productShipperGuid );
			//
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 BloodProductGuid FROM BloodProduct" );
			ps.BloodProductGuid = (Guid)dr[TABLES.ProductShipper.BloodProductGuid];
			//
			dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 LocalSupplierGuid FROM LocalSupplier" );
			ps.LocalSupplierGuid = (Guid)dr[TABLES.ProductShipper.LocalSupplierGuid];
			//
			ps.ProductCost = 179.95M;
			ps.ReturnCreditPercentage = 1.00M;
			//
			Assert.IsTrue( ps.Insert( Common.UpdateFunction.UnitTests ) );
			//
			// Clear data
			string delete = string.Concat( "DELETE FROM ProductShipper WHERE ProductShipperGuid = '", productShipperGuid, "'" );
			int count = UnitTestUtil.RunSQL( delete );
			//
			Assert.IsTrue( count == 1 );
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Insert_Fail()
		{
			Assert.IsTrue( new ProductShipper( Guid.NewGuid() ).Insert( Common.UpdateFunction.UnitTests ) );
		}

		
		[Test]
		public void Update_Pass()
		{
			this.RefreshData = true;

			this._tstPS.ProductCost = this._tstPS.ProductCost + decimal.One;

			Assert.AreEqual(true, this._tstPS.Update(Common.UpdateFunction.UnitTests));
		}

		
		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void Update_Fail()
		{
			this.RefreshData = true;

			this._tstPS.ProductCost = this._tstPS.ProductCost + decimal.One;

			this._tstPS.RowVersion = new byte[8];

			this._tstPS.Update(Common.UpdateFunction.UnitTests);
		}

	}
}
#endif


